<?php  

$botToken = "8196800097:AAFmYp2CS90VQQXm2Rg51Zq0ze3a4tYN3TQ";
$apiUrl = "https://api.telegram.org/bot$botToken";
$filePath = "shomaresh2.txt";  // پیش‌فرض مسیر فایل

// دریافت داده‌های ارسال‌شده از تلگرام
$content = file_get_contents("php://input");
$update = json_decode($content, true);

// تابع برای ایجاد فایل با مقادیر پیش‌فرض
function initializeFile($filePath) {
    $defaultContent = [
        "اشتراک های 10 گیگ = 0 عدد",
        "اشتراک های 20 گیگ = 0 عدد",
        "اشتراک های 30 گیگ = 0 عدد",
        "اشتراک های 50 گیگ = 0 عدد",
        "اشتراک های 100 گیگ = 0 عدد"
    ];
    file_put_contents($filePath, implode(PHP_EOL, $defaultContent));
}

// تابع برای پردازش فایل و افزایش یا کاهش عدد
function updateFile($filePath, $number, $operation = "subtract") {  // تغییر در default operation به "subtract"
    // اگر فایل وجود ندارد یا خالی است، آن را مقداردهی اولیه کن
    if (!file_exists($filePath) || filesize($filePath) === 0) {
        initializeFile($filePath);
    }

    // خواندن فایل
    $fileLines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $updatedLines = [];
    $lineUpdated = false;

    // سطر مربوطه را پیدا کن و مقدار را تغییر بده
    foreach ($fileLines as $line) {
        if (strpos($line, "اشتراک های $number گیگ") !== false) {
            // استخراج عدد فعلی از سطر
            preg_match('/=\s*(\d+)/', $line, $lineMatches);
            $currentCount = isset($lineMatches[1]) ? (int)$lineMatches[1] : 0;

            // عملیات افزایش یا کاهش
            if ($operation === "subtract" && $currentCount > 0) {  // عملیات کسر با بررسی اینکه عدد منفی نشود
                $currentCount--;
            }

            // به‌روزرسانی سطر
            $line = preg_replace('/=\s*\d+/', "= $currentCount", $line);
            $lineUpdated = true;
        }
        $updatedLines[] = $line;
    }

    // اگر عدد مربوطه در فایل نبود
    if (!$lineUpdated) {
        return "عدد موردنظر در فایل یافت نشد.";
    }

    // بازنویسی فایل
    file_put_contents($filePath, implode(PHP_EOL, $updatedLines));

    return "";  // فقط عملیات ذخیره انجام می‌شود، هیچ خروجی ارسال نمی‌شود
}

// تابع برای ارسال محتویات فایل
function sendFileContent($chatId, $filePath, $apiUrl) {
    // بررسی وجود فایل و خواندن محتوای آن
    if (file_exists($filePath)) {
        $fileContent = file_get_contents($filePath);
        // ارسال محتوا به چت
        file_get_contents("$apiUrl/sendMessage?chat_id=$chatId&text=" . urlencode($fileContent));
    } else {
        file_get_contents("$apiUrl/sendMessage?chat_id=$chatId&text=فایل پیدا نشد.");
    }
}

// بررسی پیام جدید
if (isset($update["message"]) || isset($update["channel_post"])) {
    $message = isset($update["message"]) ? $update["message"] : $update["channel_post"];
    $chatId = $message["chat"]["id"];
    $text = isset($message["text"]) ? $message["text"] : "";

    // بررسی اینکه آیا متن شامل "qazi.lol" یا "ghazi.lol" است
    if (strpos($text, "qazi.lol") !== false || strpos($text, "ghazi.lol") !== false) {
        $filePath = "shomaresh2.txt";  // تغییر مسیر فایل به shomaresh2.txt
    } else {
        $filePath = "shomaresh3.txt";  // تغییر مسیر فایل به shomaresh3.txt
    }

    // اگر پیام با "♨️ اشتراک" شروع شد
    if (strpos($text, "♨️ اشتراک") === 0) {
        // بررسی اینکه آیا پیام حاوی دو علامت "#" است
  
            // عدد را از متن پیام استخراج کن
            preg_match('/\d+/', $text, $matches);
            $number = isset($matches[0]) ? $matches[0] : null;

            if ($number !== null) {
                // کاهش عدد در فایل
                updateFile($filePath, $number, "subtract");  // عملیات کاهش انجام می‌شود
            } else {
                // ارسال پیام خطا اگر عدد یافت نشد
                // این قسمت را حذف کردیم تا هیچ پیامی ارسال نشود
            }
        
    }

    // اگر پیام حاوی کلمه "تعداد" باشد
    if (strpos($text, "تعداد") !== false) {
        // ارسال محتوای فایل
        sendFileContent($chatId, $filePath, $apiUrl);
    }
}

// بررسی پیام ویرایش‌شده
?>
