<?php
// بارگذاری کلاس تبدیل تاریخ
require_once 'jDateTime.php';
// === تنظیمات ===
$botToken = "8504043856:AAHmqCUUzjsA0z3nC3_0ltxe1G-SCfb0y4E"; // توکن ربات را اینجا بگذارید
$apiUrl = "https://api.telegram.org/bot" . $botToken . "/";
$ADMIN_CHAT_ID = 586924831; // آیدی عددی ادمین
// کلید رمزگذاری (می‌توانید این را تغییر دهید)
$ENCRYPTION_KEY = "YourSecretKey12345678901234567890"; // 32 کاراکتر برای AES-256
$ENCRYPTION_IV = "YourInitVector16"; // 16 کاراکتر برای IV
// تابع رمزگذاری
function encryptData($data) {
    global $ENCRYPTION_KEY, $ENCRYPTION_IV;
    $method = "AES-256-CBC";
    $encrypted = openssl_encrypt($data, $method, $ENCRYPTION_KEY, 0, $ENCRYPTION_IV);
    return base64_encode($encrypted);
}
// تابع رمزگشایی
function decryptData($encryptedData) {
    global $ENCRYPTION_KEY, $ENCRYPTION_IV;
    $method = "AES-256-CBC";
    $decrypted = openssl_decrypt(base64_decode($encryptedData), $method, $ENCRYPTION_KEY, 0, $ENCRYPTION_IV);
    return $decrypted;
}
// تابع خواندن فایل رمزگشایی شده
function readEncryptedFile($filename) {
    if (!file_exists($filename)) {
        return [];
    }
    
    $content = file_get_contents($filename);
    if (trim($content) === "") {
        return [];
    }
    
    $entries = array_values(array_filter(array_map('trim', explode("\n\n", $content))));
    $decryptedEntries = [];
    
    foreach ($entries as $entry) {
        $decrypted = decryptData($entry);
        if ($decrypted !== false) {
            $decryptedEntries[] = $decrypted;
        }
    }
    
    return $decryptedEntries;
}
// تابع نوشتن فایل رمزگذاری شده
function writeEncryptedFile($filename, $entries) {
    $encryptedEntries = [];
    foreach ($entries as $entry) {
        $encryptedEntries[] = encryptData($entry);
    }
    
    $content = implode("\n\n", $encryptedEntries);
    if (!empty($content)) {
        $content .= "\n\n";
    }
    
    file_put_contents($filename, $content, LOCK_EX);
}
// تابع اضافه کردن ورودی رمزگذاری شده
function appendEncryptedEntry($filename, $entry) {
    $encryptedEntry = encryptData($entry);
    
    $content = file_get_contents($filename);
    if ($content === false) {
        $content = "";
    }
    
    if (trim($content) !== "") {
        $content .= "\n\n";
    }
    
    $content .= $encryptedEntry;
    file_put_contents($filename, $content, LOCK_EX);
}
// تابع خواندن تمام ورودی‌ها
function getAllEntries($filename) {
    return readEncryptedFile($filename);
}
// تابع ذخیره با شماره‌گذاری مجدد
function saveWithRenumberEncrypted($entries, $filename) {
    // رمزگذاری هر ورودی
    $encryptedEntries = [];
    foreach ($entries as $entry) {
        $encryptedEntries[] = encryptData($entry);
    }
    
    $content = implode("\n\n", $encryptedEntries);
    if (!empty($content)) {
        $content .= "\n\n";
    }
    
    file_put_contents($filename, $content, LOCK_EX);
    return $entries;
}
// تابع پاک کردن فایل
function clearEncryptedFile($filename) {
    file_put_contents($filename, "", LOCK_EX);
}
// تابع خواندن محتوای خام (برای بررسی)
function readRawContent($filename) {
    return file_get_contents($filename);
}
// تابع خواندن ورودی‌ها با شماره برای حذف/ویرایش
function getEntriesWithNumbers($filename) {
    $entries = readEncryptedFile($filename);
    $result = [];
    
    foreach ($entries as $entry) {
        $lines = explode("\n", $entry);
        $firstLine = $lines[0] ?? '';
        
        if (preg_match('/^(\d+)-/', $firstLine, $matches)) {
            $number = (int)$matches[1];
        } else {
            $number = null;
        }
        
        $result[] = [
            'number' => $number,
            'entry' => $entry
        ];
    }
    
    return $result;
}
// تابع پیدا کردن ورودی با شماره
function findEntryByNumber($filename, $targetNumber) {
    $entries = readEncryptedFile($filename);
    
    foreach ($entries as $entry) {
        $lines = explode("\n", $entry);
        $firstLine = $lines[0] ?? '';
        
        if (preg_match('/^(\d+)-/', $firstLine, $matches)) {
            $number = (int)$matches[1];
            if ($number === $targetNumber) {
                return $entry;
            }
        }
    }
    
    return null;
}
// تابع حذف ورودی با شماره
function deleteEntryByNumber($filename, $targetNumber) {
    $entries = readEncryptedFile($filename);
    $newEntries = [];
    $found = false;
    
    foreach ($entries as $entry) {
        $lines = explode("\n", $entry);
        $firstLine = $lines[0] ?? '';
        
        if (preg_match('/^(\d+)-/', $firstLine, $matches)) {
            $number = (int)$matches[1];
            if ($number === $targetNumber) {
                $found = true;
                continue;
            }
        }
        
        $newEntries[] = $entry;
    }
    
    if ($found) {
        // شماره‌گذاری مجدد
        $renumbered = renumberEntries($newEntries);
        saveWithRenumberEncrypted($renumbered, $filename);
        return true;
    }
    
    return false;
}
// تابع شماره‌گذاری مجدد
function renumberEntries($entries) {
    $new_entries = [];
    $counter = 1;
    foreach ($entries as $entry) {
        $entry = trim($entry);
        if (empty($entry)) continue;
        $entry_lines = explode("\n", $entry);
        $first_line = $entry_lines[0];
        if (preg_match('/^\d+-(.*)/', $first_line, $matches)) {
            $entry_lines[0] = $matches[1];
        } elseif (is_numeric(trim($first_line))) {
            array_shift($entry_lines);
        }
        $entry_lines[0] = $counter . '-' . $entry_lines[0];
        $new_entries[] = trim(implode("\n", $entry_lines));
        $counter++;
    }
    return $new_entries;
}
// تابع پیدا کردن ورودی با نام خانوادگی
function findEntriesByName($filename, $targetName) {
    $entries = readEncryptedFile($filename);
    $foundEntries = [];
    
    foreach ($entries as $entry) {
        if (preg_match("/#فامیل\s*:\s*" . preg_quote($targetName, '/') . "\s*$/mu", $entry)) {
            $foundEntries[] = $entry;
        }
    }
    
    return $foundEntries;
}
// تابع حذف ورودی با نام
function deleteEntriesByName($filename, $targetName) {
    $entries = readEncryptedFile($filename);
    $newEntries = [];
    $deletedCount = 0;
    
    foreach ($entries as $entry) {
        if (preg_match("/#فامیل\s*:\s*" . preg_quote($targetName, '/') . "\s*$/mu", $entry)) {
            $deletedCount++;
            continue;
        }
        $newEntries[] = $entry;
    }
    
    if ($deletedCount > 0) {
        $renumbered = renumberEntries($newEntries);
        saveWithRenumberEncrypted($renumbered, $filename);
        return $deletedCount;
    }
    
    return 0;
}
// تابع جستجو با آیدی یا نام
function searchEntries($filename, $param, $isEnglish) {
    $entries = readEncryptedFile($filename);
    $foundEntries = [];
    
    foreach ($entries as $entry) {
        $isMatch = false;
        if ($isEnglish) {
            if (preg_match("/#آیدی\s*:\s*" . preg_quote($param, '/') . "\s*$/mu", $entry)) {
                $isMatch = true;
            }
        } else {
            if (preg_match("/#فامیل\s*:\s*" . preg_quote($param, '/') . "\s*$/mu", $entry)) {
                $isMatch = true;
            }
        }
        if ($isMatch) {
            $foundEntries[] = $entry;
        }
    }
    
    return $foundEntries;
}
// تابع جستجو با شماره
function searchEntryByNumber($filename, $targetNumber) {
    $entries = readEncryptedFile($filename);
    
    foreach ($entries as $entry) {
        $lines = explode("\n", $entry);
        if (preg_match('/^(\d+)-/', $lines[0], $matches)) {
            $num = (int)$matches[1];
            if ($num === $targetNumber) {
                return $entry;
            }
        }
    }
    
    return null;
}
// تابع به‌روزرسانی ورودی
function updateEntry($filename, $targetNumber, $newEntry) {
    $entries = readEncryptedFile($filename);
    $newEntries = [];
    $found = false;
    
    foreach ($entries as $entry) {
        $lines = explode("\n", $entry);
        
        if (preg_match('/^(\d+)-/', $lines[0], $matches)) {
            $num = (int)$matches[1];
        } else {
            $num = (int)trim($lines[0]);
        }
        if ($num === $targetNumber) {
            $newEntries[] = trim($newEntry);
            $found = true;
        } else {
            $newEntries[] = $entry;
        }
    }
    
    if ($found) {
        $renumbered = renumberEntries($newEntries);
        saveWithRenumberEncrypted($renumbered, $filename);
        return true;
    }
    
    return false;
}
// تابع جستجو با تاریخ
function searchEntriesByDate($filename, $date1_raw, $date2_raw = null) {
    $entries = readEncryptedFile($filename);
    $foundEntries = [];
    
    foreach ($entries as $entry) {
        $entryDate = extract_entry_date_value($entry);
        if ($entryDate === '') continue;
        $entryInt = parse_file_date_to_jalali_int($entryDate);
        if ($entryInt === null) continue;
        $startInt = parse_jalali_numeric_date_to_int($date1_raw);
        if ($startInt === null) continue;
        if ($date2_raw === null) {
            if ($entryInt === $startInt) {
                $foundEntries[] = $entry;
            }
        } else {
            $endInt = parse_jalali_numeric_date_to_int($date2_raw);
            if ($endInt === null) continue;
            
            if ($entryInt >= $startInt && $entryInt <= $endInt) {
                $foundEntries[] = $entry;
            }
        }
    }
    
    return $foundEntries;
}
// تابع دریافت تمام ورودی‌ها
function getAllEntriesList($filename) {
    return readEncryptedFile($filename);
}
// تابع ذخیره ورودی جدید
function saveNewEntry($filename, $entry) {
    appendEncryptedEntry($filename, $entry);
}
// تابع دریافت تعداد ورودی‌ها
function getEntryCount($filename) {
    $entries = readEncryptedFile($filename);
    return count($entries);
}
// ==== بقیه کد اصلی ====
$update = json_decode(file_get_contents("php://input"), true);
if (!$update || !isset($update['message'])) {
    exit;
}
$message = $update['message'];
$chat_id = $message['chat']['id'];
$text = trim($message['text'] ?? '');
// حذف پیشوندهای #آیدی :   #پسورد :   #فامیل :
$text = preg_replace('/^#آیدی\s*:\s*/um', '', $text);
$text = preg_replace('/^#پسورد\s*:\s*/um', '', $text);
$text = preg_replace('/^#فامیل\s*:\s*/um', '', $text);
// تبدیل خطوط چندگانه به آرایه
$lines = preg_split('/\r\n|\r|\n/', trim($text));
$clean_lines = array_filter(array_map('trim', $lines), 'strlen');
// تبدیل @ انتهایی به @gmail.com



$lines = explode("\n", $text);
if (!empty($lines) && str_ends_with(trim($lines[0]), '@')) {
    $lines[0] = rtrim(trim($lines[0]), '@') . '@gmail.com';
}
$text = implode("\n", $lines);
if ((int)$chat_id !== (int)$ADMIN_CHAT_ID) {
    exit;
}
if ($text === '') {
    exit;
}
// ==== تبدیل اعداد فارسی/عربی به لاتین ====
function persian_to_english_digits($string) {
    $persian = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
    $arabic  = ['٠','١','٢','٣','٤','٥','٦','٧','٨','٩'];
    $english = ['0','1','2','3','4','5','6','7','8','9'];
    $string = str_replace($persian, $english, $string);
    $string = str_replace($arabic,  $english, $string);
    return $string;
}
function normalize_text($s) {
    $s = persian_to_english_digits($s);
    $s = str_replace(["\u{200C}", "\u{200F}", "\u{200E}"], '', $s);
    $s = str_replace(['،', ','], ' ', $s);
    $s = preg_replace('/\s+/u', ' ', trim($s));
    return $s;
}
function is_jalali_numeric_date($s) {
    $s = normalize_text($s);
    $s = str_replace('-', '/', $s);
    return (bool)preg_match('/^\d{4}\/\d{1,2}\/\d{1,2}$/', $s);
}
function jalali_date_to_int($jy, $jm, $jd) {
    return ((int)$jy) * 10000 + ((int)$jm) * 100 + ((int)$jd);
}
function parse_jalali_numeric_date_to_int($numericDate) {
    $numericDate = normalize_text($numericDate);
    $numericDate = str_replace('-', '/', $numericDate);
    if (!preg_match('/^(\d{4})\/(\d{1,2})\/(\d{1,2})$/', $numericDate, $m)) {
        return null;
    }
    $jy = (int)$m[1];
    $jm = (int)$m[2];
    $jd = (int)$m[3];
    if ($jy < 1200 || $jy > 1700) return null;
    if ($jm < 1 || $jm > 12) return null;
    if ($jd < 1 || $jd > 31) return null;
    return jalali_date_to_int($jy, $jm, $jd);
}
function parse_file_date_to_jalali_int($fileDate) {
    $s = normalize_text($fileDate);
    $months = [
        'فروردین' => 1,
        'اردیبهشت' => 2,
        'خرداد' => 3,
        'تیر' => 4,
        'مرداد' => 5,
        'شهریور' => 6,
        'مهر' => 7,
        'آبان' => 8,
        'آذر' => 9,
        'دی' => 10,
        'بهمن' => 11,
        'اسفند' => 12,
    ];
    if (preg_match('/(\d{1,2})\s+(فروردین|اردیبهشت|خرداد|تیر|مرداد|شهریور|مهر|آبان|آذر|دی|بهمن|اسفند)\s+(\d{4})/u', $s, $m)) {
        $jd = (int)$m[1];
        $monthName = $m[2];
        $jy = (int)$m[3];
        $jm = $months[$monthName] ?? 0;
        if ($jm < 1) return null;
        if ($jd < 1 || $jd > 31) return null;
        return jalali_date_to_int($jy, $jm, $jd);
    }
    return null;
}
function extract_entry_date_value($entry) {
    if (preg_match('/^#تاریخ\s*:\s*(.+)$/mu', $entry, $m)) {
        return trim($m[1]);
    }
    return '';
}
// ==== مرحله ۱: تبدیل اعداد فارسی به لاتین در کل متن ورودی ====
$text = persian_to_english_digits($text);
// ==== مرحله ۲: استخراج آیدی اینستاگرام از هر خطی که لینک داره ====
$lines_temp = explode("\n", $text);
$lines = [];
foreach ($lines_temp as $line) {
    $line = trim($line);
    if ($line === '') continue;
    if (strpos($line, 'http') === 0 && stripos($line, 'instagram.com') !== false) {
        if (preg_match('/instagram\.com\/([a-zA-Z0-9_.]+)/i', $line, $matches)) {
            $line = $matches[1];
        }
    }
    $lines[] = $line;
}
$text = implode("\n", $lines);
$lines = array_values(array_filter(array_map('trim', explode("\n", $text))));
$first_line = $lines[0] ?? '';
if ($text === '') {
    exit;
}
$filename = "customers.txt";
if (!file_exists($filename)) {
    file_put_contents($filename, "");
}
function sendMessage($chat_id, $text, $reply_markup = null) {
    global $apiUrl;
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'disable_web_page_preview' => true,
    ];
    if ($reply_markup) {
        $data['reply_markup'] = json_encode($reply_markup);
    }
    file_get_contents($apiUrl . "sendMessage?" . http_build_query($data));
}
function getJalaliDate() {
    $jDate = new jDateTime(true, true, 'Asia/Tehran');
    return $jDate->date("l j F Y", false, false);
}
// ==== /start ====
if ($text === '/start') {
    $keyboard = [
        'keyboard' => [
            [ ['text' => 'اطلاعات'] ],
        ],
        'resize_keyboard' => true,
    ];
    sendMessage($chat_id, "یکی از گزینه‌ها را انتخاب کن:", $keyboard);
    exit;
}
// ==== دستور کارخانه (حذف کامل همه مشتریان) ====
if ($text === "کارخانه") {
    clearEncryptedFile($filename);
    sendMessage($chat_id, "✅ کارخانه فعال شد!\nتمام اطلاعات مشتریان با موفقیت پاک شد و فایل خالی گردید.");
    exit;
}
// خواندن تمام ورودی‌ها
$entries = getAllEntries($filename);
// ==== دستور اطلاعات (به‌روزرسانی شده: تک‌تاریخ یا بازه تاریخ) ====
if (preg_match('/^اطلاعات(\s+.*)?$/u', $first_line)) {
    if (empty($entries)) {
        sendMessage($chat_id, "هنوز هیچ اطلاعاتی ذخیره نشده.");
        exit;
    }
    // پارامتر بعد از کلمه اطلاعات (اگر در همان خط نوشته شده باشد)
    $param_raw = preg_replace('/^اطلاعات\s*/u', '', $first_line);
    $param_raw = trim($param_raw);
    $date1_raw = '';
    $date2_raw = '';
    // حالت: اطلاعات 1404/08/09 1404/08/22
    if ($param_raw !== '') {
        $tokens = preg_split('/\s+/u', normalize_text($param_raw));
        $t1 = $tokens[0] ?? '';
        $t2 = $tokens[1] ?? '';
        if ($t1 !== '' && is_jalali_numeric_date($t1)) $date1_raw = $t1;
        if ($t2 !== '' && is_jalali_numeric_date($t2)) $date2_raw = $t2;
    }
    // حالت: اطلاعات\n1404/08/09\n1404/08/22
    if ($param_raw === '') {
        if (isset($lines[1]) && is_jalali_numeric_date($lines[1])) {
            $date1_raw = $lines[1];
        }
        if (isset($lines[2]) && is_jalali_numeric_date($lines[2])) {
            $date2_raw = $lines[2];
        }
    }
    // اگر تک‌تاریخ یا بازه تاریخ بود
    if ($date1_raw !== '') {
        $startInt = parse_jalali_numeric_date_to_int($date1_raw);
        if ($startInt === null) {
            sendMessage($chat_id, "فرمت تاریخ نامعتبر است. نمونه: 1404/09/28");
            exit;
        }
        $endInt = null;
        if ($date2_raw !== '') {
            $endInt = parse_jalali_numeric_date_to_int($date2_raw);
            if ($endInt === null) {
                sendMessage($chat_id, "فرمت تاریخ دوم نامعتبر است. نمونه: 1404/09/28");
                exit;
            }
        }
        // اگر بازه برعکس ارسال شده بود، جابجا کن
        if ($endInt !== null && $endInt < $startInt) {
            $tmp = $startInt;
            $startInt = $endInt;
            $endInt = $tmp;
            $tmpRaw = $date1_raw;
            $date1_raw = $date2_raw;
            $date2_raw = $tmpRaw;
        }
        $found_entries = [];
        foreach ($entries as $entry) {
            $entryDate = extract_entry_date_value($entry);
            if ($entryDate === '') continue;
            $entryInt = parse_file_date_to_jalali_int($entryDate);
            if ($entryInt === null) continue;
            if ($endInt === null) {
                // تک روز
                if ($entryInt === $startInt) {
                    $found_entries[] = $entry;
                }
            } else {
                // بازه
                if ($entryInt >= $startInt && $entryInt <= $endInt) {
                    $found_entries[] = $entry;
                }
            }
        }
        if (empty($found_entries)) {
            if ($endInt === null) {
                sendMessage($chat_id, "برای تاریخ $date1_raw موردی پیدا نشد.");
            } else {
                sendMessage($chat_id, "برای بازه $date1_raw تا $date2_raw موردی پیدا نشد.");
            }
        } else {
            sendMessage($chat_id, implode("\n\n", $found_entries));
        }
        exit;
    }
    // اگر فقط "اطلاعات" بود و تاریخ هم نداشت → کل لیست
    if ($param_raw === "") {
        sendMessage($chat_id, implode("\n\n", $entries));
        exit;
    }
    
    if (is_numeric($param_raw)) {
        $target_number = (int)$param_raw;
        $found = false;
        foreach ($entries as $entry) {
            $entry_lines = explode("\n", $entry);
            if (preg_match('/^(\d+)-/', $entry_lines[0], $matches)) {
                $num = (int)$matches[1];
                if ($num === $target_number) {
                    $found = true;
                    // استخراج آیدی از خط اول
                    if (preg_match('/#آیدی\s*:\s*([a-zA-Z0-9_.]+)/u', $entry, $id_match)) {
                        $instagram_id = $id_match[1];
                        // خط اول رو اصلاح کن: شماره + -#آیدی :  (بدون لینک در این خط)
                        $entry_lines[0] = $matches[1] . "-#آیدی :";
                        // لینک رو به عنوان خط دوم اضافه کن
                        array_splice($entry_lines, 1, 0, ["https://www.instagram.com/" . $instagram_id]);
                        // اگر خطوط بعدی (پسورد و ...) وجود داشته باشن، جابجا می‌شن
                    }
                    // بقیه خطوط بدون تغییر
                    $modified_entry = implode("\n", $entry_lines);
                    sendMessage($chat_id, $modified_entry);
                    break;
                }
            }
        }
        if (!$found) {
            sendMessage($chat_id, "شماره $target_number پیدا نشد.");
        }
        exit;
    }
    // حالت قبلی: جستجو بر اساس آیدی یا فامیل
    if (strpos($param_raw, 'instagram.com/') !== false) {
        preg_match('/instagram\.com\/([a-zA-Z0-9_.]+)/', $param_raw, $matches);
        $param_raw = $matches[1] ?? $param_raw;
    }
    $param = trim($param_raw);
    $isEnglish = preg_match('/^[a-zA-Z0-9_]+$/', $param);
    $found_entries = searchEntries($filename, $param, $isEnglish);
    if (empty($found_entries)) {
        sendMessage($chat_id, "پیدا نشد.");
    } else {
        sendMessage($chat_id, implode("\n\n", $found_entries));
    }
    exit;
}
// ==== دستور حذف ====
if (strpos($first_line, "حذف") === 0) {
    $param = trim(substr($first_line, strlen("حذف")));
    if (is_numeric($param)) {
        $target_number = (int)$param;
        $found = deleteEntryByNumber($filename, $target_number);
        if ($found) {
            sendMessage($chat_id, "مشتری شماره $target_number با موفقیت حذف شد و شماره‌گذاری به‌روزرسانی شد.");
        } else {
            sendMessage($chat_id, "شماره $target_number پیدا نشد.");
        }
    } else {
        // حذف با نام (دقیق)
        $target_name = $param;
        $deleted_count = deleteEntriesByName($filename, $target_name);
        if ($deleted_count > 0) {
            sendMessage($chat_id, "تمام مشتریان با #فامیلی '$target_name' حذف شدند ($deleted_count نفر) و شماره‌گذاری به‌روزرسانی شد.");
        } else {
            sendMessage($chat_id, "هیچ مشتری با #فامیلی '$target_name' پیدا نشد.");
        }
    }
    exit;
}
// ==== دستور ویرایش ====
if (strpos($first_line, "ویرایش") === 0) {
    $number_param = trim(substr($first_line, strlen("ویرایش")));
    if (!is_numeric($number_param)) {
        sendMessage($chat_id, "لطفاً شماره معتبر بعد از 'ویرایش' بنویسید.");
        exit;
    }
    $target_number = (int)$number_param;
    $edit_lines = array_slice($lines, 1);
    if (count($edit_lines) < 2) {
        sendMessage($chat_id, "لطفاً #آیدی و #پسورد جدید را در خطوط بعدی بنویسید.");
        exit;
    }
    $instagram_id = '';
    $first_edit_line = $edit_lines[0];
    if (strpos($first_edit_line, 'instagram.com/') !== false) {
        preg_match('/instagram\.com\/([a-zA-Z0-9_.]+)/', $first_edit_line, $matches);
        $instagram_id = $matches[1] ?? $first_edit_line;
    } else {
        $instagram_id = $first_edit_line;
    }
    $password = '';
    $name = '';
    foreach (array_slice($edit_lines, 1) as $line) {
        if ($password === '' && preg_match('/[a-zA-Z0-9]/', $line)) {
            $password = $line;
            continue;
        }
        if ($name === '') {
            $name = trim($line);
        }
    }
    if ($instagram_id === '' || $password === '') {
        sendMessage($chat_id, "#آیدی یا #پسورد معتبر نیست.");
        exit;
    }
    $jalali_date = getJalaliDate();
    $new_entry_content  = $target_number . "-#آیدی : " . $instagram_id . "\n";
    $new_entry_content .= "#پسورد : " . $password . "\n";
    if ($name !== '') {
        $new_entry_content .= "#فامیل : " . $name . "\n";
    }
    $new_entry_content .= "#تاریخ : " . $jalali_date;
    $found = updateEntry($filename, $target_number, $new_entry_content);
    if ($found) {
        $reply  = "مشتری شماره $target_number با موفقیت ویرایش شد:\n\n";
        $reply .= "#آیدی : " . $instagram_id . "\n";
        $reply .= "#پسورد : " . $password . "\n";
        if ($name !== '') $reply .= "#فامیل : " . $name . "\n";
        $reply .= "#تاریخ : " . $jalali_date;
        sendMessage($chat_id, $reply);
    } else {
        sendMessage($chat_id, "شماره $target_number پیدا نشد.");
    }
    exit;
}
// ==== اضافه کردن مشتری جدید ====
$instagram_id = '';
if (strpos($first_line, 'instagram.com/') !== false) {
    preg_match('/instagram\.com\/([a-zA-Z0-9_.]+)/', $first_line, $matches);
    $instagram_id = $matches[1] ?? $first_line;
} else {
    $instagram_id = $first_line;
}
$remaining_lines = array_slice($lines, 1);
$password = '';
$name = '';
foreach ($remaining_lines as $line) {
    if ($password === '' && preg_match('/[a-zA-Z0-9]/', $line)) {
        $password = $line;
        continue;
    }
    if ($name === '') {
        $name = trim($line);
    }
}
if ($instagram_id === '' || $password === '') {
    exit;
}
$jalali_date = getJalaliDate();
$current_count = getEntryCount($filename) + 1;
$new_entry  = $current_count . "-#آیدی : " . $instagram_id . "\n";
$new_entry .= "#پسورد : " . $password . "\n";
if ($name !== '') {
    $new_entry .= "#فامیل : " . $name . "\n";
}
$new_entry .= "#تاریخ : " . $jalali_date;
$new_entry = trim($new_entry);
saveNewEntry($filename, $new_entry);
$reply_text  = "اطلاعات ذخیره شد (شماره $current_count):\n\n";
$reply_text .= "#آیدی : " . $instagram_id . "\n";
$reply_text .= "#پسورد : " . $password . "\n";
if ($name !== '') {
    $reply_text .= "#فامیل : " . $name . "\n";
}
$reply_text .= "#تاریخ : " . $jalali_date;
sendMessage($chat_id, $reply_text);
exit;