    <?php
    // نمایش خطاها برای دیباگ (بعد از تست موفق می‌تونی حذف یا کامنت کنی)
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
    
    require_once __DIR__ . '/jDateTime.php';
    
    // تنظیمات ربات
    $botToken = '8019361847:AAFMbPTX6xE8VhUxIc9kicUb2f3h7W-mYJg';
    $chatId   = '586924831';
    
    // پایه آدرس API تلگرام
    $apiUrl = "https://api.telegram.org/bot{$botToken}/";
    
    // ─── تابع ارسال فایل به تلگرام ───
    function sendToTelegram($filePath, $caption, $apiUrl, $chatId) {
        if (!file_exists($filePath)) {
            echo "فایل یافت نشد: $filePath\n";
            return false;
        }
    
        $fileName = basename($filePath);
    
        $ch = curl_init($apiUrl . 'sendDocument');
        curl_setopt_array($ch, [
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'chat_id'  => $chatId,
                'document' => new CURLFile($filePath, mime_content_type($filePath) ?: 'application/octet-stream', $fileName),
                'caption'  => $caption,
            ],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 300,           // برای فایل‌های بزرگ‌تر
            CURLOPT_SSL_VERIFYPEER => false,
        ]);
    
        $response = curl_exec($ch);
        $error    = curl_error($ch);
        curl_close($ch);
    
        if ($error) {
            echo "خطای cURL در ارسال $fileName: $error\n";
            return false;
        }
    
        $result = json_decode($response, true);
        if (isset($result['ok']) && $result['ok'] === true) {
            echo "ارسال موفق: $fileName\n";
            return true;
        } else {
            echo "خطا از تلگرام در $fileName: " . ($result['description'] ?? 'نامشخص') . "\n";
            return false;
        }
    }
    
    // ─── بخش ۱: ارسال بکاپ‌های ویزویز (.sql) ───
    $directory_wzwiz = '/home/sajsbs/public_html/packup_wzwiz/';
    $files_sql = glob($directory_wzwiz . '*.sql');
    
    if (!empty($files_sql)) {
        // جدیدترین‌ها اول
        usort($files_sql, function($a, $b) {
            return filemtime($b) - filemtime($a);
        });
    
        $filesToSend = array_slice($files_sql, 0, 3); // حداکثر ۳ تا
    
        foreach ($filesToSend as $filePath) {
            $timestamp   = filemtime($filePath);
            $jdate       = new jDateTime(true, true);
            $persianDate = $jdate->date("l j F Y - H:i", $timestamp);
    
            $caption = "بکاپ ویزویز\nفایل: " . basename($filePath) . "\nتاریخ: $persianDate";
            sendToTelegram($filePath, $caption, $apiUrl, $chatId);
        }
    } else {
        echo "هیچ فایل .sql در پوشه ویزویز پیدا نشد.\n";
    }
    
    // ─── بخش ۲: ارسال بکاپ هاست (فایل zip) ───
    $directory_host = '/home/sajsbs/public_html/backuphost/';
    $files_zip = glob($directory_host . 'backup-*.zip');   // یا '*.zip' اگر همه زیپ‌ها رو می‌خوای
    
    if (!empty($files_zip)) {
        // جدیدترین فایل zip
        usort($files_zip, function($a, $b) {
            return filemtime($b) - filemtime($a);
        });
    
        $latest_zip = $files_zip[0]; // جدیدترین
    
        $timestamp   = filemtime($latest_zip);
        $jdate       = new jDateTime(true, true);
        $persianDate = $jdate->date("l j F Y - H:i", $timestamp);
    
        $caption = "بکاپ هاست\nفایل: " . basename($latest_zip) . "\nتاریخ: $persianDate";
        sendToTelegram($latest_zip, $caption, $apiUrl, $chatId);
    } else {
        echo "هیچ فایل backup-*.zip در پوشه backuphost پیدا نشد.\n";
    }
    
// ─── ارسال فایل customers.txt ───
$customers_file = __DIR__ . '/customers.txt';

if (file_exists($customers_file)) {
    $caption = "فایل مشتریان\n" . basename($customers_file);
    sendToTelegram($customers_file, $caption, $apiUrl, $chatId);
} else {
    echo "فایل customers.txt پیدا نشد.\n";
}


// ─── ارسال فایل matn.txt ───
$matn_file = '/home/sajsbs/public_html/config/matn.txt';

if (file_exists($matn_file)) {
    $caption = "فایل matn.txt";
    sendToTelegram($matn_file, $caption, $apiUrl, $chatId);
} else {
    echo "فایل matn.txt پیدا نشد.\n";
}



echo "\nعملیات به پایان رسید.\n";
    ?>