<?php
// تنظیمات کلی
$backup_dir = 'packup_wzwiz';

// ایجاد پوشه اگر وجود نداشته باشد
if (!is_dir($backup_dir)) {
    mkdir($backup_dir, 0755, true);
}

// لیست دیتابیس‌ها
$databases = [
    [
        'host' => 'localhost',
        'user' => 'sajsbs_ghazi',
        'pass' => 'sajad8041',
        'name' => 'sajsbs_sajad',
        'file' => $backup_dir . '/backup_sajad1.sql'
    ],
    [
        'host' => 'localhost',
        'user' => 'sajsbs_ghazi2',
        'pass' => 'sajad8041',
        'name' => 'sajsbs_sajad2',
        'file' => $backup_dir . '/backup_sajad2.sql'
    ],
    [
        'host' => 'localhost',
        'user' => 'sajsbs_ghazi3',
        'pass' => 'sajad8041',
        'name' => 'sajsbs_sajad3',
        'file' => $backup_dir . '/backup_sajad3.sql'
    ]
];

echo "<pre>\n";
echo "شروع بک‌آپ‌گیری از " . count($databases) . " دیتابیس\n";
echo "تاریخ و ساعت: " . date('Y-m-d H:i:s') . "\n\n";

$success_count = 0;

foreach ($databases as $db) {
    $host = $db['host'];
    $user = $db['user'];
    $pass = $db['pass'];
    $name = $db['name'];
    $file = $db['file'];

    echo "→ بک‌آپ: $name  →  $file\n";

    // دستور mysqldump - با نقل‌قول برای مسیر فایل (برای ایمنی)
    $command = sprintf(
        "mysqldump -h %s -u %s -p%s %s > %s 2>&1",
        escapeshellarg($host),
        escapeshellarg($user),
        escapeshellarg($pass),
        escapeshellarg($name),
        escapeshellarg($file)
    );

    $output = [];
    $return_var = 0;
    exec($command, $output, $return_var);

    if ($return_var === 0 && file_exists($file) && filesize($file) > 200) {
        $size = round(filesize($file) / 1048576, 2);
        echo "    موفق ✓   حجم ≈ $size MB\n\n";
        $success_count++;
    } else {
        echo "    خطا ✗\n";
        if ($output) {
            echo "    خروجی mysqldump:\n      " . implode("\n      ", $output) . "\n";
        }
        echo "\n";
    }
}

echo "──────────────────────────────\n";
echo "نتیجه نهایی:\n";
echo "  موفق: $success_count از " . count($databases) . " دیتابیس\n";
if ($success_count === count($databases)) {
    echo "همه بک‌آپ‌ها بدون مشکل انجام شد.\n";
} else {
    echo "بعضی بک‌آپ‌ها خطا داشتند (بالا را چک کنید).\n";
}
echo "</pre>";

// اختیاری: اگر می‌خواهی لاگ هم ذخیره شود
// file_put_contents("$backup_dir/backup_log.txt", date('c') . " - $success_count موفق\n", FILE_APPEND);
?>