<?php  

$botToken = "8060123747:AAHwYl6xoHCmDN-FWqUNWPgzqz_hoO_4Lgg";
$apiUrl = "https://api.telegram.org/bot$botToken";

// شناسه کانال مورد نظر
$targetChannelId = "-1002312993051";

// دریافت داده‌های ارسال‌شده از تلگرام
$content = file_get_contents("php://input");
$update = json_decode($content, true);

if (strpos($text, "سلام") !== false) {
    exit;
}

// تابع برای ایجاد فایل با مقادیر پیش‌فرض
function initializeFile($filePath) {
    $defaultContent = [
        "اشتراک های 10 گیگ = 0 عدد",
        "اشتراک های 20 گیگ = 0 عدد",
        "اشتراک های 30 گیگ = 0 عدد",
        "اشتراک های 50 گیگ = 0 عدد",
        "اشتراک های 100 گیگ = 0 عدد"
    ];
    file_put_contents($filePath, implode(PHP_EOL, $defaultContent));
}

// تابع برای پردازش فایل و افزایش یا کاهش عدد
function updateFile($filePath, $number, $operation = "add") {
    if (!file_exists($filePath) || filesize($filePath) === 0) {
        initializeFile($filePath);
    }

    // خواندن فایل
    $fileLines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $updatedLines = [];
    $lineUpdated = false;

    // سطر مربوطه را پیدا کن و مقدار را تغییر بده
    foreach ($fileLines as $line) {
        if (strpos($line, "اشتراک های $number گیگ") !== false) {
            preg_match('/=\s*(\d+)/', $line, $lineMatches);
            $currentCount = isset($lineMatches[1]) ? (int)$lineMatches[1] : 0;

            // عملیات افزایش یا کاهش
            if ($operation === "add") {
                $currentCount++;
            } elseif ($operation === "subtract" && $currentCount > 0) {
                $currentCount--;
            }

            // به‌روزرسانی سطر
            $line = preg_replace('/=\s*\d+/', "= $currentCount", $line);
            $lineUpdated = true;
        }
        $updatedLines[] = $line;
    }

    if (!$lineUpdated) {
        return "عدد موردنظر در فایل یافت نشد.";
    }

    file_put_contents($filePath, implode(PHP_EOL, $updatedLines));
    return "";
}

// تابع برای ارسال محتویات فایل
function sendFileContent($chatId, $filePath, $apiUrl) {
    if (file_exists($filePath)) {
        $fileContent = file_get_contents($filePath);
        $response = file_get_contents("$apiUrl/sendMessage?chat_id=$chatId&text=" . urlencode($fileContent));
        return json_decode($response, true); // گرفتن شناسه پیام ارسال شده
    } else {
        $response = file_get_contents("$apiUrl/sendMessage?chat_id=$chatId&text=فایل پیدا نشد.");
        return json_decode($response, true); // گرفتن شناسه پیام ارسال شده
    }
}

// بررسی پیام جدید
if (isset($update["message"]) || isset($update["channel_post"])) {
    $message = isset($update["message"]) ? $update["message"] : $update["channel_post"];
    $chatId = $message["chat"]["id"];
    $text = isset($message["text"]) ? $message["text"] : "";

    // تعیین مسیر فایل بر اساس کانال فرستنده
    $filePath = ($chatId == $targetChannelId) ? "shomaresh2.txt" : "shomaresh3.txt";

    // اگر پیام با "♨️ اشتراک" شروع شد
    if (strpos($text, "♨️ اشتراک") === 0) {
        preg_match('/\d+/', $text, $matches);
        $number = isset($matches[0]) ? $matches[0] : null;

        if ($number !== null) {
            updateFile($filePath, $number, "add");
        }
    }

    // اگر پیام دقیقاً "تعداد" باشد
  if (trim($text) === "تعداد") {
    // ارسال محتوای فایل و دریافت شناسه پیام
    $sent_message = sendFileContent($chatId, $filePath, $apiUrl);

    if (isset($sent_message['result']['message_id'])) {
        $message_id = $sent_message['result']['message_id'];

        // انتظار 5 ثانیه
        sleep(5);

        // حذف پیام محتوای فایل
        file_get_contents("$apiUrl/deleteMessage?chat_id=$chatId&message_id=$message_id");

        // حذف پیام اصلی "تعداد"
        $user_message_id = $message["message_id"];
        file_get_contents("$apiUrl/deleteMessage?chat_id=$chatId&message_id=$user_message_id");
    }
}

    // اگر پیام "پاک" بود
    if ($text == "پاک") {
        file_put_contents($filePath, "");
        file_get_contents("$apiUrl/sendMessage?chat_id=$chatId&text=فایل پاک شد.");
    }
}

?>
