<?php
// تنظیمات اولیه
require $_SERVER['DOCUMENT_ROOT'] . '/vpn/jDateTime.php'; // وارد کردن کتابخانه تبدیل تاریخ
$botToken = "8096652401:AAEWcXaRCEsQQK5pZtoSJoDpgI_HDM75350";
$apiUrl = "https://api.telegram.org/bot$botToken/";

// خواندن داده‌های دریافتی از Telegram
$content = file_get_contents("php://input");
$update = json_decode($content, true);

// بررسی اینکه آیا پیام جدید دریافت شده است
if (isset($update["message"])) {
    $chatId = $update["message"]["chat"]["id"];
    $text = $update["message"]["text"];

    // الگوی جستجوی تاریخ میلادی
    $pattern = '/\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}/';

    // تابع تبدیل حجم به گیگابایت
    $toGB = function($value, $unit) {
        switch($unit) {
            case 'B': return $value / (1024 * 1024 * 1024);
            case 'KB': return $value / (1024 * 1024);
            case 'MB': return $value / 1024;
            case 'GB': default: return $value;
        }
    };

    // تابع تبدیل اعداد فارسی به انگلیسی
    $convertToEnglish = function($string) {
        $persianNumbers = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
        $englishNumbers = ['0','1','2','3','4','5','6','7','8','9'];
        return str_replace($persianNumbers, $englishNumbers, $string);
    };

    // کلاس تاریخ شمسی
    $jDateTime = new jDateTime(true, true, 'Asia/Tehran');

    $shamsiDate = "هنوز شروع نشده";
    $shamsiTime = "نامشخص";
    $remainingDays = 30;

    // جستجو و پردازش تاریخ انقضا
    if (preg_match($pattern, $text, $matches)) {
        // حالت تاریخ میلادی
        $miladiDate = $matches[0];
        $timestamp = strtotime($miladiDate);
        $currentTimestamp = time();
      //  $remainingDays = ceil(($timestamp - $currentTimestamp) / (60 * 60 * 24));
$remainingDays = max(ceil(($timestamp - $currentTimestamp) / (60 * 60 * 24)), 0);




        $shamsiDate = $jDateTime->date("Y/m/d", $timestamp);
        $shamsiTime = date("H:i:s", $timestamp);

        $shamsiDate = $convertToEnglish($shamsiDate);
        $shamsiTime = $convertToEnglish($shamsiTime);
        $remainingDays = $convertToEnglish((string)$remainingDays);

    } elseif (preg_match('/باقیمانده از انقضا: (\d+) ساعت/', $text, $hourMatches)) {
        // حالت وقتی فقط "X ساعت" مونده
        $hoursLeft = (int)$hourMatches[1];
        $currentTimestamp = time();
        $timestamp = $currentTimestamp + ($hoursLeft * 3600);

        //$remainingDays = ceil($hoursLeft / 24);
$remainingDays = max(ceil($hoursLeft / 24), 0);



        $shamsiDate = $jDateTime->date("Y/m/d", $timestamp);
        $shamsiTime = date("H:i:s", $timestamp);

        $shamsiDate = $convertToEnglish($shamsiDate);
        $shamsiTime = $convertToEnglish($shamsiTime);
        $remainingDays = $convertToEnglish((string)$remainingDays);
    }

    // استخراج ایمیل
    preg_match('/📧 ایمیل: (\w+)/', $text, $emailMatches);
    $email = isset($emailMatches[1]) ? $emailMatches[1] : 'نامشخص';

    // استخراج حجم مصرفی و حجم کل از متن
    preg_match('/📊 کل: ([\d.]+)([BKMG]B) \/ ([\d.]+)([BKMG]B)/', $text, $matchesVolume);

    if ($matchesVolume) {
        $usedValue = isset($matchesVolume[1]) ? (float)$matchesVolume[1] : 0;
        $usedUnit = isset($matchesVolume[2]) ? $matchesVolume[2] : 'GB';
        $totalValue = isset($matchesVolume[3]) ? (float)$matchesVolume[3] : 0;
        $totalUnit = isset($matchesVolume[4]) ? $matchesVolume[4] : 'GB';

        $usedGB = number_format($toGB($usedValue, $usedUnit), 2);
        $totalGB = number_format($toGB($totalValue, $totalUnit), 2);
        //$remain = number_format($totalGB - $usedGB, 2);
        $remain = number_format(max($totalGB - $usedGB, 0), 2);
        
        
    } else {
        $usedGB = $totalGB = $remain = "0.00";
    }

    // ساخت متن پاسخ به فرمت درخواستی
    $responseText = "✅ نام سرور: $email\n\n";
    $responseText .= "📅 تاریخ انقضا: $shamsiDate\n";
    $responseText .= "🕖 ساعت: $shamsiTime\n\n";
    $responseText .= "📦 حجم کل: $totalGB گیگ\n";
    $responseText .= "📈 حجم مصرفی: $usedGB گیگ\n";
    $responseText .= "📉 حجم باقیمانده: $remain گیگ\n\n";
    $responseText .= "⏳ تعداد روز باقیمانده: $remainingDays روز";

    // ارسال پاسخ
    file_get_contents($apiUrl . "sendMessage?chat_id=$chatId&text=" . urlencode($responseText));
}
?>
