<?php


$errorLogFile = __DIR__ . "/error_log";
if (file_exists($errorLogFile)) {
    if (unlink($errorLogFile)) {
        echo "فایل error_log با موفقیت حذف شد.\n";
    } else {
        echo "عدم موفقیت در حذف فایل error_log، ممکن است فایل در حال استفاده باشد.\n";
    }
}



$botToken = "8190124207:AAEjNwOrFUpP8g8Mbezv9nfXziHUCO81jJs";

// فایل‌های مورد استفاده
$statusFile = __DIR__ . "/dokme.txt";
$timeFile = __DIR__ . "/zaman.txt";
$customTimeFile = __DIR__ . "/time.txt";
// تابع برای نوشتن لاگ
function logMessage($message) {
    global $logFile;
    $timestamp = date("Y-m-d H:i:s");  // زمان نوشتن لاگ
    file_put_contents($logFile, "[$timestamp] $message\n", FILE_APPEND);
}
// تابع ارسال پیام به تلگرام
function sendTelegramMessage($chatId, $message, $botToken) {
    $url = "https://api.telegram.org/bot$botToken/sendMessage";
    $postData = ['chat_id' => $chatId, 'text' => $message, 'parse_mode' => 'HTML'];
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        logMessage("خطا در ارسال پیام به تلگرام: " . curl_error($ch));
    } else {
        logMessage("پیام به تلگرام ارسال شد: $response");
    }
    curl_close($ch);
}

function isPingable($host) {
//     بررسی اتصال به سرور با استفاده از fsockopen
   $connection = @fsockopen($host, 80, $errno, $errstr, 1); // بررسی پورت 80 با تایم‌اوت 1 ثانیه
   if (is_resource($connection)) {
      fclose($connection); // اگر اتصال برقرار شد، ارتباط را می‌بندیم
       logMessage("سرور $host در دسترس است");
        return true;
    } else {
        logMessage("سرور $host در دسترس نیست: $errstr ($errno)");
        return false;
    }
}
// خواندن فایل ip.txt
$file = "ip.txt";
if (!file_exists($file)) {
    logMessage("فایل ip.txt پیدا نشد");
    die("\nفایل ip.txt پیدا نشد\n");
}
$data = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

// خواندن وضعیت قبلی سرورها
$currentStatus = [];
if (file_exists($statusFile)) {
    $statusData = file($statusFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($statusData as $statusLine) {
        list($currentChatId, $currentIp, $currentStatusValue) = explode(" | ", $statusLine);
        $currentChatId = trim(str_replace("چت ایدی: ", "", $currentChatId));
        $currentIp = trim(str_replace("ایپی: ", "", $currentIp));
        $currentStatus[$currentChatId . $currentIp] = $statusLine;
    }
}

// خواندن زمان‌ها
$timeData = [];
if (file_exists($timeFile)) {
    $timeLines = file($timeFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($timeLines as $timeLine) {
        list($chatId, $ip, $time) = explode(" | ", $timeLine);
        $chatId = trim(str_replace("چت ایدی: ", "", $chatId));
        $ip = trim(str_replace("ایپی: ", "", $ip));
        $time = intval(trim(str_replace("زمان قطع: ", "", $time)));
        $timeData[$chatId . $ip] = $time;
    }
}

// خواندن زمان‌های مجاز از فایل time.txt
$customTime = [];
if (file_exists($customTimeFile)) {
    $customTimeLines = file($customTimeFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($customTimeLines as $line) {
        if (strpos($line, "چت ایدی:") !== false) {
            $chatId = trim(str_replace("چت ایدی:", "", $line));
        } elseif (strpos($line, "عدد:") !== false) {
            $timeLimit = intval(trim(str_replace("عدد:", "", $line)));
            $customTime[$chatId] = $timeLimit;
        }
    }
}

// پردازش اطلاعات
$newTimeData = [];
$chatId = $ip = $name = null;
foreach ($data as $line) {
    $line = trim($line);
    if (strpos($line, "چت ایدی :") !== false) {
        $chatId = trim(str_replace("چت ایدی :", "", $line));
    } elseif (strpos($line, "آیپی:") !== false) {
        $ip = trim(str_replace("آیپی:", "", $line));
    } elseif (strpos($line, "نام آیپی :") !== false) {
        $name = trim(str_replace("نام آیپی :", "", $line));
    }

    if ($chatId && $ip && $name) {
        $isActive = isPingable($ip);
        $status = $isActive ? "فعال" : "غیر فعال";
        $key = $chatId . $ip;
        $timeLimit = isset($customTime[$chatId]) ? $customTime[$chatId] : 1;

        // بررسی وضعیت
        if (!$isActive) {
            $timeData[$key] = isset($timeData[$key]) ? $timeData[$key] + 1 : 1;
            if ($timeData[$key] > $timeLimit) {
                if (!isset($currentStatus[$key]) || strpos($currentStatus[$key], "وضعیت: فعال") !== false) {
                    $message = "❌ اتصال سرور: $name\nبا آیپی : ($ip)\nغیر فعال شد";
                    sendTelegramMessage($chatId, $message, $botToken);
                }
                $currentStatus[$key] = "چت ایدی: $chatId | ایپی: $ip | وضعیت: $status";
            }
        } else {
            if (isset($timeData[$key]) && $timeData[$key] > $timeLimit) {
                $message = "✅ اتصال سرور: $name\nبا آیپی : ($ip)\nفعال شد";
                sendTelegramMessage($chatId, $message, $botToken);
            }
            $timeData[$key] = 0;
            $currentStatus[$key] = "چت ایدی: $chatId | ایپی: $ip | وضعیت: $status";
        }

        // ذخیره زمان‌ها
        $newTimeData[] = "چت ایدی: $chatId | ایپی: $ip | زمان قطع: " . $timeData[$key] . " دقیقه";
        $chatId = $ip = $name = null;
    }
}

// به‌روزرسانی فایل‌ها
if (file_put_contents($statusFile, implode("\n", $currentStatus)) === false) {
    logMessage("خطا در نوشتن به فایل $statusFile");
} else {
    logMessage("فایل $statusFile با موفقیت به‌روزرسانی شد");
}

if (file_put_contents($timeFile, implode("\n", $newTimeData)) === false) {
    logMessage("خطا در نوشتن به فایل $timeFile");
} else {
    logMessage("فایل $timeFile با موفقیت به‌روزرسانی شد");
}
?>
