<?php
// backup_sender.php

// توکن ربات تلگرام (بهتره بعداً از env یا فایل جدا بخونیش)
$botToken = '7928431608:AAH7DP4X-DUvA_ZaMKEuV-WYLPDVt_ChP_o';
$statusFile = __DIR__ . '/send.txt';
// مسیر فایل لیست chat_id ها
$chatIdsFile = __DIR__ . '/chat_id.txt';

// آدرس API تلگرام
$apiUrl = "https://api.telegram.org/bot{$botToken}";

// تابع ارسال پیام
function sendMessage($chat_id, $text, $botToken) {
    $url = "https://api.telegram.org/bot{$botToken}/sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    file_get_contents($url . '?' . http_build_query($data));
}

// تابع ارسال فایل (Document)
function sendDocument($chat_id, $filePath, $botToken) {
    $url = "https://api.telegram.org/bot{$botToken}/sendDocument";

    $post_fields = [
        'chat_id' => $chat_id,
        'document' => new CURLFile(realpath($filePath))
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $result = curl_exec($ch);
    curl_close($ch);

    $response = json_decode($result, true);
    return $response['ok'] ?? false;
}

// شروع اسکریپت
if (!file_exists($chatIdsFile)) {
    die("فایل chat_id.txt پیدا نشد!\n");
}

$lines = file($chatIdsFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$sentCount = 0;
$failedCount = 0;

echo "شروع ارسال پشتیبان‌ها - " . date('Y-m-d H:i:s') . "\n";

// خواندن وضعیت فایل send.txt
$sendStatus = file_exists($statusFile) ? trim(file_get_contents($statusFile)) : '';

if (in_array($sendStatus, ['ارسال شده', 'ارسالی شده'])) {
    echo "فایل قبلاً ارسال شده است. ارسال متوقف شد.\n";
    die();
}

foreach ($lines as $line) {
    $line = trim($line);
    if ($line === '' || in_array(substr($line, 0, 1), ['#', '/', ';'])) {
        continue;
    }
    $chat_id = $line;
    $jsonFile = __DIR__ . "/customer_data_{$chat_id}.json";

    if (!file_exists($jsonFile)) {
        $text = "♻️ فایل پشتیبان آخر شب ♻️\n\n";
        $text .= "⚠️ هنوز هیچ بک‌آپی برای شما ثبت نشده است.\n";
        $text .= "تاریخ: " . jdate('Y/m/d H:i:s');
        sendMessage($chat_id, $text, $botToken);
        echo "[$chat_id] فایل json وجود ندارد - فقط پیام ارسال شد\n";
        continue;
    }

    $fileTime = filemtime($jsonFile);
    $persianDate = function_exists('jdate') ? jdate('Y/m/d H:i:s', $fileTime) : date('Y/m/d H:i:s', $fileTime);

    $success = sendDocument($chat_id, $jsonFile, $botToken);

    $statusEmoji = $success ? "✅" : "❌";
    $text = "♻️ فایل پشتیبان آخر شب ♻️\n\n";
    $text .= "{$statusEmoji} وضعیت ارسال: " . ($success ? "موفق" : "ناموفق") . "\n";
    $text .= "📅 تاریخ فایل: <b>{$persianDate}</b>\n";
    sendMessage($chat_id, $text, $botToken);

    if ($success) {
        $sentCount++;
        echo "[$chat_id] فایل با موفقیت ارسال شد\n";
    } else {
        $failedCount++;
        echo "[$chat_id] خطا در ارسال فایل!\n";
    }
    usleep(300000);
}

// بعد از اتمام حلقه، فایل send.txt را با متن «ارسال شده» پر کن
file_put_contents($statusFile, 'ارسال شده');

echo "\nتمام شد! ارسال موفق: $sentCount - ناموفق: $failedCount\n";

echo "\nتمام شد! ارسال موفق: $sentCount - ناموفق: $failedCount\n";