<?php

// ---------------- تنظیمات ----------------
$botToken = "8585477038:AAE7Qv8xL-3lqd1-CTd2-348f0GC2UGaf7I";
$chatId = "586924831"; // آیدی خودت یا کانال
$serverFile = __DIR__ . "/server.txt"; 
$warnFile = __DIR__ . "/warn_count.txt"; 
$maxWarnings = 3; // حداکثر هشدار

// ------- اگر فایل warn_count نباشه، ایجادش کن -------
if (!file_exists($warnFile)) {
    file_put_contents($warnFile, "0");
}

// -------- خواندن تعداد هشدارهای قبلی --------
$warnCount = intval(trim(file_get_contents($warnFile)));

// -------- خواندن لیست سرورها --------
if (!file_exists($serverFile)) {
    exit("server.txt not found");
}

$content = file_get_contents($serverFile);
preg_match_all('/vless:\/\//i', $content, $matches);
$count = count($matches[0]);

// -------- اگر تعداد سرورها کمتر از 6 بود --------
if ($count < 3) {

    // اگر هنوز سه بار هشدار نداده‌ایم
    if ($warnCount < $maxWarnings) {

        $warnCount++;
        file_put_contents($warnFile, $warnCount);

        $message = "⚠️ هشدار:
تعداد سرورها کمتر از حد مجاز است.
📌 تعداد فعلی: $count
🔁 تعداد هشدارهای ارسال‌شده: $warnCount / $maxWarnings";

        sendMessage($botToken, $chatId, $message);
    }

} else {
    // اگر تعداد به حالت نرمال برگشت → ریست شمارنده هشدار
    if ($warnCount > 0) {
        file_put_contents($warnFile, "0");
    }
}

echo "Checked. Count: $count, Warnings used: $warnCount";


// ---------------- تابع ارسال پیام ----------------
function sendMessage($token, $chat_id, $text) {
    $url = "https://api.telegram.org/bot$token/sendMessage";

    $data = [
        "chat_id" => $chat_id,
        "text" => $text,
        "parse_mode" => "Markdown"
    ];

    file_get_contents($url . "?" . http_build_query($data));
}