<?php 

// توکن ربات تلگرام
$botToken = "7690191796:AAEZPpWGcEti1B--gM5NEVQrEHwStHmAteM";
// آدرس URL ارسال پیام
$telegramApiUrl = "https://api.telegram.org/bot$botToken/sendMessage";

// فایل‌های مورد استفاده
$filePath = "zaman.txt"; // فایل زمان‌بندی اصلی
$logFilePath = "sent_log.txt"; // فایل لاگ برای ثبت چت‌آیدی‌های پردازش‌شده
$logFilePath2 = "sent_log2.txt"; // فایل جدید برای ثبت چت‌آیدی پیام‌های 24 ساعته

// اطمینان از وجود فایل‌های لاگ
if (!file_exists($logFilePath)) {
    file_put_contents($logFilePath, "");
}

if (!file_exists($logFilePath2)) {
    file_put_contents($logFilePath2, "");
}

// خواندن محتوای فایل zaman.txt
if (!file_exists($filePath)) {
    die("فایل زمان پیدا نشد.");
}

$fileContent = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

// خواندن چت‌آیدی‌هایی که قبلاً پیام ارسال شده‌اند
$sentLog = file($logFilePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$sentLog2 = file($logFilePath2, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

for ($i = 0; $i < count($fileContent); $i += 3) {
    // استخراج اطلاعات چت آیدی و زمان
    $chatIdLine = $fileContent[$i];
    $dateLine = $fileContent[$i + 1];
    $timeLine = $fileContent[$i + 2];

    // استخراج چت آیدی
    $chatIdParts = explode("-", $chatIdLine);
    $chatId = end($chatIdParts);

    // بررسی اینکه پیام قبلاً ارسال شده یا خیر
    if (in_array($chatId, $sentLog)) {
        continue; // پیام قبلاً ارسال شده است
    }

    // ترکیب تاریخ و زمان
    $scheduledTime = $dateLine . " " . $timeLine;

    // تبدیل زمان زمان‌بندی‌شده به timestamp
    $scheduledTimestamp = strtotime($scheduledTime);
    if ($scheduledTimestamp === false) {
        continue; // ادامه در صورت وجود خطا در زمان
    }

    // زمان فعلی
    $currentTimestamp = time();

    // مقایسه زمان‌ها
    if ($currentTimestamp > $scheduledTimestamp) {
        // ارسال پیام به چت آیدی
        $message = "✅ هم اکنون میتوانید سرور تست را مجدد دریافت کنید 😊";
        $response = sendMessageToTelegram($telegramApiUrl, $chatId, $message);

        // بررسی موفقیت ارسال پیام
        $responseData = json_decode($response, true);
        if (isset($responseData['ok']) && $responseData['ok'] === true) {
            // پیام با موفقیت ارسال شد، ثبت چت‌آیدی در فایل لاگ
            appendChatIdToFile($logFilePath, $chatId);
        }
    } elseif ($scheduledTimestamp - $currentTimestamp <= 86400) {
        // بررسی اینکه چت‌آیدی در فایل sent_log2.txt وجود دارد یا خیر
        if (!in_array($chatId, $sentLog2)) {
            // ارسال پیام هشدار
            $message = "❗️ مهلت سرور 1 روزه شما به پایان رسید\nتا 5 روز دیگر میتوانید سرور را مجدد دریافت کنید";
            $response = sendMessageToTelegram($telegramApiUrl, $chatId, $message);

            // بررسی موفقیت ارسال پیام
            $responseData = json_decode($response, true);
            if (isset($responseData['ok']) && $responseData['ok'] === true) {
                // ثبت چت‌آیدی در فایل sent_log2.txt
                appendChatIdToFile($logFilePath2, $chatId);
            }
        }
    }
}

// تابع ارسال پیام به تلگرام
function sendMessageToTelegram($url, $chatId, $message)
{
    $postData = [
        'chat_id' => $chatId,
        'text' => $message,
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}

// تابع ثبت چت‌آیدی در اولین خط خالی
function appendChatIdToFile($filePath, $chatId)
{
    $fileContents = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    // اضافه کردن چت‌آیدی به انتهای فایل با یک خط خالی
    $fileContents[] = $chatId;

    // ذخیره مجدد فایل با خطوط خالی استاندارد
    file_put_contents($filePath, implode(PHP_EOL, $fileContents) . PHP_EOL);
}
